SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_STUDENT_MARKED_ABSENT_FOR_THE_SESSION_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    scad.id AS ID,\n    T1.courseVariantCode AS COURSE_VARIANT_CODE,\n    T7.firstName AS FIRST_NAME,\n    T7.lastName AS LAST_NAME,\n    T7.emailId AS EMAIL_ID,\n    T7.alternateEmailId AS ALTERNATE_EMAIL_ID,\n    T7.mobileNumber AS MOBILE_NO,\n    T7.mobileCountryCode AS MOBILE_CODE,\n    T8.displayName AS ACADEMY_NAME,\n    T9.salutationName AS SALUTATION_NAME,\n    DATE_FORMAT(sca.dateOfAttendance, \'%d-%m-%Y\') AS SESSION_DATE,\n    DATE_FORMAT(sca.fromTime, \'%h:%i %p\') AS SLOT_FROM,\n    DATE_FORMAT(sca.toTime, \'%h:%i %p\') AS SLOT_TO\nFROM\n    student_course_attendance sca\n        LEFT JOIN\n    student_course_attendance_details scad ON sca.id = scad.attendanceId\n        LEFT JOIN\n    course_variants T1 ON T1.id = sca.variantId\n        LEFT JOIN\n    admission T5 ON T5.id = scad.admissionId\n        LEFT JOIN\n    students T6 ON T6.userId = T5.studentId\n        LEFT JOIN\n    persons T7 ON T7.id = T6.personId\n        LEFT JOIN\n    salutations T9 ON T9.id = T7.salutationId\n        LEFT JOIN\n    academy_location T8 ON T8.id = sca.academyLocationId\nWHERE\n    scad.attendanceStatus = \'ABSENT\'\n        AND scad.id IN (namedParams)', `jsonString`='{\n \"id\": 1,\n     \"searchResultViewColumns\": [\n        {\n            \"id\": 1,\n            \"value\": \"id\",\n            \"resultKey\": \"ID\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 0\n        },        \n        {\n            \"id\": 2,\n            \"value\": \"firstName\",\n            \"resultKey\": \"FIRST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 1\n        },       \n        {\n            \"id\": 3,\n            \"value\": \"lastName\",\n            \"resultKey\": \"LAST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 2\n        },\n        {\n            \"id\": 4,\n            \"value\": \"sessionDate\",\n            \"resultKey\": \"SESSION_DATE\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 3\n        },\n		{\n            \"id\": 5,\n            \"value\": \"courseVariantCode\",\n            \"resultKey\": \"COURSE_VARIANT_CODE\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 4\n        },\n		{\n            \"id\": 6,\n            \"value\": \"displayName\",\n            \"resultKey\": \"ACADEMY_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 5\n        },\n		{\n            \"id\": 7,\n            \"value\": \"SLOT_FROM\",\n            \"resultKey\": \"SLOT_FROM\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 6\n        },\n		{\n            \"id\": 8,\n            \"value\": \"SLOT_TO\",\n            \"resultKey\": \"SLOT_TO\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 7\n        },\n        {\n            \"id\": 9,\n            \"value\": \"salutationName\",\n            \"resultKey\": \"SALUTATION_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 8\n        }\n    ]}' WHERE `dataProviderId`=@dtproviderId;
